# College Event Management System

A PHP-based web application for managing college events, tracking participant attendance via QR codes, and assigning points for games.

## Features
- **Participant Registration:** Students can register and generate a unique QR code.
- **QR Code Scanning:** Admins can scan participant QR codes to assign points.
- **Leaderboard:** Real-time ranking of participants based on points.
- **Admin Roles:** Separate panels for Super Admins (System Management) and Game Controllers (Point Assignment).
- **System Health:** Tools to check database integrity and server status.

## Folder Structure

```text
college-event-system/
├── app/                # Backend logic and database scripts
│   ├── database.sql    # SQL schema for database setup
│   └── seed_admins.php # Script to create default admin accounts
├── config/             # Configuration files
│   └── database.php    # Database connection settings
├── public/             # Web root (accessible via browser)
│   ├── css/            # Stylesheets
│   ├── index.php       # Landing page
│   ├── register.php    # Student registration page
│   ├── profile.php     # Student dashboard & QR code
│   ├── scan.php        # Admin QR scanner & point assignment
│   ├── ranking.php     # Public leaderboard
│   ├── admin_*.php     # Admin dashboards and tools
│   └── ...
├── views/              # HTML templates (Header, Footer)
└── README.md           # Project documentation
```

## Installation Steps

1.  **Deploy Code:**
    - Place the `college-event-system` folder in your web server's root directory (e.g., `htdocs` for XAMPP).

2.  **Database Setup:**
    - Create a new MySQL database named `macma2025`.
    - Import the `app/database.sql` file into your database using a tool like phpMyAdmin.
    - *Alternative:* You can run `public/fix_db.php` in your browser to create the necessary tables automatically.

3.  **Configuration:**
    - Open `config/database.php`.
    - Update the `$dbHost`, `$dbUser`, and `$dbPass` variables to match your local database credentials.

4.  **Create Admin Accounts:**
    - Run the seeder script to create default accounts. If `seed_admins.php` is in `app/`, you may need to move it to `public/` temporarily to run it via browser, or execute it via command line: `php app/seed_admins.php`.

## Default Credentials

**Super Admin:**
- **Username:** `super`
- **Password:** `password123`

**Game Controller (Admin):**
- **Username:** `admin`
- **Password:** `password123`

## Requirements
- PHP 7.4 or higher
- MySQL 5.7 or higher