<?php
// config/database.php

// 1. Session Management
ini_set('session.cookie_httponly', 1);
ini_set('session.use_strict_mode', 1);

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// 2. Session Timeout (30 minutes)
$timeout_duration = 1800;
if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity']) > $timeout_duration) {
    $is_admin = isset($_SESSION['admin_id']);
    session_unset();
    session_destroy();
    $path_prefix = (isset($GLOBALS['path_depth']) && $GLOBALS['path_depth'] === 1) ? '../' : '';
    $redirect = $is_admin ? $path_prefix . 'admin_login.php' : $path_prefix . 'login.php';
    header("Location: $redirect?timeout=1");
    exit;
}
$_SESSION['last_activity'] = time();

// Database credentials placeholder
$dbHost = 'localhost';
$dbName = 'macma2025';
$dbUser = 'root';
$dbPass = '';

try {
    $pdo = new PDO("mysql:host=$dbHost;dbname=$dbName;charset=utf8mb4", $dbUser, $dbPass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    header("Location: error.php?msg=Database Connection Failed");
    exit;
}
?>
