<?php
// public/participant/edit_profile.php
$GLOBALS['path_depth'] = 1;
require_once '../../config/database.php';

if (!isset($_SESSION['unique_id'])) {
    header("Location: ../login.php");
    exit;
}

$unique_id = $_SESSION['unique_id'];
$message = '';
$error = '';

// Fetch current details
$stmt = $pdo->prepare("SELECT * FROM participants WHERE unique_id = ?");
$stmt->execute([$unique_id]);
$user = $stmt->fetch();

if (!$user) {
    header("Location: ../login.php");
    exit;
}

// Check for existing pending request
$stmt = $pdo->prepare("SELECT * FROM profile_edit_requests WHERE participant_id = ? AND status = 'pending'");
$stmt->execute([$user['id']]);
$pendingRequest = $stmt->fetch();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if ($pendingRequest) {
        $error = "You already have a pending request. Please wait for approval.";
    } else {
        $name = trim($_POST['name']);
        $college = trim($_POST['college']);
        $year = trim($_POST['year']);
        $department = trim($_POST['department']);
        $phone = trim($_POST['phone']);

        if (empty($name) || empty($college) || empty($year) || empty($department) || empty($phone)) {
            $error = "All fields are required.";
        } else {
            $stmt = $pdo->prepare("INSERT INTO profile_edit_requests (participant_id, new_name, new_college, new_year, new_department, new_phone) VALUES (?, ?, ?, ?, ?, ?)");
            $stmt->execute([$user['id'], $name, $college, $year, $department, $phone]);
            $message = "Request submitted successfully! Waiting for admin approval.";
            // Refresh pending request check
            $pendingRequest = true; 
        }
    }
}

?>
<!DOCTYPE html>
<html class="dark" lang="en"><head>
<meta charset="utf-8"/>
<meta content="width=device-width, initial-scale=1.0" name="viewport"/>
<title>MAGMA 2025 Edit Profile Request</title>
<link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;700;800;900&display=swap" rel="stylesheet"/>
<link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:wght,FILL@100..700,0..1&display=swap" rel="stylesheet"/>
<script src="https://cdn.tailwindcss.com?plugins=forms,container-queries"></script>
<script id="tailwind-config">
        tailwind.config = {
            darkMode: "class",
            theme: {
                extend: {
                    colors: {
                        "primary-accent": "#FF00FF", // Magenta
                        "secondary-accent": "#FF5F1F", // Electric Orange
                        "background-dark": "#050505",
                        "text-light": "#ffffff",
                        "text-dark": "#0a0a0a",
                        "placeholder-color": "#666666",
                        "input-bg-dark": "#121212",
                        "input-border-dark": "#2a2a2a",
                        "surface-dark": "#0f0f0f",
                        "warning-accent": "#FFD700", // Gold/Yellow
                    },
                    fontFamily: {
                        "display": ["Montserrat", "sans-serif"]
                    },
                    borderRadius: {
                        "DEFAULT": "0.5rem",
                        "lg": "1rem",
                        "xl": "1rem",
                        "2xl": "1.5rem",
                        "full": "9999px"
                    },
                    animation: {
                        'pulse-slow': 'pulse 3s cubic-bezier(0.4, 0, 0.6, 1) infinite',
                    }
                },
            },
        }
    </script>
<link rel="stylesheet" href="../css/edit_profile.css">
  </head>
<body class="bg-background-dark text-text-light font-display">
<div class="fixed inset-0 bg-pattern"></div>
<div class="fixed inset-0 noise-overlay"></div>
<div class="fixed top-[-10%] right-[-10%] w-[400px] h-[400px] bg-primary-accent rounded-full blur-[130px] opacity-20 pointer-events-none animate-pulse"></div>
<div class="fixed bottom-[5%] left-[-15%] w-[350px] h-[350px] bg-secondary-accent rounded-full blur-[100px] opacity-15 pointer-events-none mix-blend-screen"></div>
<div class="relative flex h-full min-h-screen w-full flex-col overflow-x-hidden z-10">
<div class="flex-1 flex flex-col items-center justify-center px-5 py-6 w-full max-w-lg mx-auto">
<div class="w-full flex flex-col items-center mb-8 relative group">
<div class="relative mb-4">
<div class="absolute inset-0 bg-secondary-accent blur-xl opacity-30 rounded-full scale-110 group-hover:scale-125 transition-transform duration-500"></div>
<div class="relative w-20 h-20 bg-gradient-to-br from-primary-accent to-purple-800 rounded-2xl -rotate-3 flex items-center justify-center shadow-xl border border-white/10 z-10">
<span class="material-symbols-outlined text-4xl text-white drop-shadow-md rotate-3">edit_document</span>
</div>
</div>
<h1 class="text-white tracking-tighter text-5xl font-black leading-none text-center italic uppercase drop-shadow-lg text-glow transform -skew-x-6">
                    MAGMA<span class="text-secondary-accent">.</span>25
                </h1>
<div class="h-1 w-16 bg-gradient-to-r from-transparent via-secondary-accent to-transparent mt-3 mb-2"></div>
<p class="text-gray-400 text-xs font-bold tracking-[0.3em] mt-1 text-center uppercase">
                    Edit Profile Request
                </p>
</div>
<div class="w-full space-y-4 backdrop-blur-md bg-surface-dark/70 p-6 rounded-2xl border border-white/10 shadow-2xl relative overflow-hidden transition-all duration-300">
<div class="absolute top-0 left-0 w-full h-[2px] bg-gradient-to-r from-transparent via-primary-accent to-transparent opacity-50"></div>
<?php if ($message): ?>
    <div class="p-3 mb-4 text-sm text-green-500 bg-green-100/10 border border-green-500/50 rounded-lg">
        <?php echo htmlspecialchars($message); ?>
    </div>
<?php endif; ?>
<?php if ($error): ?>
    <div class="p-3 mb-4 text-sm text-red-500 bg-red-100/10 border border-red-500/50 rounded-lg">
        <?php echo htmlspecialchars($error); ?>
    </div>
<?php endif; ?>

<?php if ($pendingRequest): ?>
<div class="flex flex-col items-center justify-center py-6 text-center space-y-5 animate-pulse-slow">
<div class="w-24 h-24 rounded-full bg-warning-accent/10 flex items-center justify-center border border-warning-accent/40 shadow-[0_0_40px_rgba(255,215,0,0.2)]">
<span class="material-symbols-outlined text-5xl text-warning-accent">pending_actions</span>
</div>
<div class="space-y-2">
<h2 class="text-2xl font-black text-warning-accent uppercase tracking-wider drop-shadow-sm">Request Pending</h2>
<div class="h-1 w-12 bg-warning-accent/50 mx-auto rounded-full"></div>
</div>
<p class="text-gray-300 text-sm font-bold leading-relaxed px-2">
                        You have already submitted a request to edit your profile. This request is currently under review by the MAGMA 2025 committee.
                    </p>
<div class="w-full bg-warning-accent/5 border border-warning-accent/20 rounded-xl p-3 mt-2">
<p class="text-warning-accent/80 text-[10px] font-mono tracking-widest uppercase">Status: Awaiting Approval</p>
</div>
</div>
<?php else: ?>
<form class="space-y-4" method="POST">
<div class="flex w-full flex-col group input-glow transition-all duration-300 rounded-xl">
<label class="sr-only" for="name">Full Name</label>
<div class="relative flex items-center h-12 bg-input-bg-dark rounded-xl border border-input-border-dark group-focus-within:border-primary-accent transition-colors">
<div class="w-12 h-full flex items-center justify-center bg-white/5 border-r border-white/5 rounded-l-xl">
<span class="material-symbols-outlined text-gray-500 group-focus-within:text-primary-accent transition-colors text-xl">person</span>
</div>
<input class="form-input flex w-full bg-transparent text-white border-none h-full placeholder:text-gray-600 px-4 text-sm font-bold tracking-wide focus:outline-0 focus:ring-0" id="name" name="name" placeholder="FULL NAME" type="text" value="<?php echo htmlspecialchars($user['name']); ?>" required/>
</div>
</div>
<div class="flex w-full flex-col group input-glow transition-all duration-300 rounded-xl">
<label class="sr-only" for="college">College Name</label>
<div class="relative flex items-center h-12 bg-input-bg-dark rounded-xl border border-input-border-dark group-focus-within:border-secondary-accent transition-colors">
<div class="w-12 h-full flex items-center justify-center bg-white/5 border-r border-white/5 rounded-l-xl">
<span class="material-symbols-outlined text-gray-500 group-focus-within:text-secondary-accent transition-colors text-xl">school</span>
</div>
<input class="form-input flex w-full bg-transparent text-white border-none h-full placeholder:text-gray-600 px-4 text-sm font-bold tracking-wide focus:outline-0 focus:ring-0" id="college" name="college" placeholder="COLLEGE NAME" type="text" value="<?php echo htmlspecialchars($user['college']); ?>" required/>
</div>
</div>
<div class="flex flex-row space-x-3">
<div class="flex w-2/5 flex-col group input-glow transition-all duration-300 rounded-xl">
<label class="sr-only" for="year">Year</label>
<div class="relative flex items-center h-12 bg-input-bg-dark rounded-xl border border-input-border-dark group-focus-within:border-primary-accent transition-colors">
<div class="absolute left-3 flex items-center pointer-events-none">
<span class="text-gray-500 font-bold text-xs mr-1">YR</span>
</div>
<select class="form-select w-full bg-transparent text-white border-none h-full pl-10 pr-8 text-sm font-bold tracking-wide focus:outline-0 focus:ring-0 appearance-none cursor-pointer" id="year" name="year" required>
<option class="text-gray-500" value="">SELECT</option>
<option class="text-black" value="1" <?php echo ($user['year'] == '1') ? 'selected' : ''; ?>>1</option>
<option class="text-black" value="2" <?php echo ($user['year'] == '2') ? 'selected' : ''; ?>>2</option>
<option class="text-black" value="3" <?php echo ($user['year'] == '3') ? 'selected' : ''; ?>>3</option>
<option class="text-black" value="4" <?php echo ($user['year'] == '4') ? 'selected' : ''; ?>>4</option>
</select>
<div class="absolute right-2 pointer-events-none flex items-center">
<span class="material-symbols-outlined text-gray-500 text-sm">expand_more</span>
</div>
</div>
</div>
<div class="flex w-3/5 flex-col group input-glow transition-all duration-300 rounded-xl">
<label class="sr-only" for="department">Department</label>
<div class="relative flex items-center h-12 bg-input-bg-dark rounded-xl border border-input-border-dark group-focus-within:border-primary-accent transition-colors">
<div class="w-10 h-full flex items-center justify-center bg-white/5 border-r border-white/5 rounded-l-xl">
<span class="material-symbols-outlined text-gray-500 group-focus-within:text-primary-accent transition-colors text-lg">domain</span>
</div>
<input class="form-input flex w-full bg-transparent text-white border-none h-full placeholder:text-gray-600 px-3 text-sm font-bold tracking-wide focus:outline-0 focus:ring-0" id="department" name="department" placeholder="DEPT" type="text" value="<?php echo htmlspecialchars($user['department']); ?>" required/>
</div>
</div>
</div>
<div class="flex w-full flex-col group input-glow transition-all duration-300 rounded-xl">
<label class="sr-only" for="phone">Phone Number</label>
<div class="relative flex items-center h-12 bg-input-bg-dark rounded-xl border border-input-border-dark group-focus-within:border-secondary-accent transition-colors">
<div class="w-12 h-full flex items-center justify-center bg-white/5 border-r border-white/5 rounded-l-xl">
<span class="material-symbols-outlined text-gray-500 group-focus-within:text-secondary-accent transition-colors text-xl">call</span>
</div>
<input class="form-input flex w-full bg-transparent text-white border-none h-full placeholder:text-gray-600 px-4 text-sm font-bold tracking-wide focus:outline-0 focus:ring-0" id="phone" name="phone" placeholder="PHONE NUMBER" type="tel" value="<?php echo htmlspecialchars($user['phone']); ?>" required/>
</div>
</div>
<button class="relative w-full group cursor-pointer h-14 mt-2 overflow-hidden rounded-xl bg-gradient-to-r from-primary-accent to-purple-600 transition-all duration-300 hover:shadow-[0_0_30px_rgba(255,0,255,0.4)] active:scale-[0.98] border border-white/10" type="submit">
<div class="absolute inset-0 bg-white/20 translate-y-full group-hover:translate-y-0 transition-transform duration-500 ease-out"></div>
<div class="flex items-center justify-center h-full w-full relative z-10">
<span class="text-white text-lg font-black uppercase tracking-widest mr-2">Submit Request</span>
<span class="material-symbols-outlined text-white font-bold group-hover:translate-x-1 transition-transform">send</span>
</div>
</button>
</form>
<?php endif; ?>
</div>
<div class="w-full py-6 text-center z-10">
<a class="inline-flex items-center text-gray-400 text-xs font-bold uppercase tracking-widest hover:text-white transition-colors group pb-1 opacity-70 hover:opacity-100" href="profile.php">
<span class="material-symbols-outlined text-sm mr-2 group-hover:-translate-x-1 transition-transform">arrow_back</span>
                    Back to Profile
                </a>
</div>
</div>
</div>
</body></html>