<?php
$GLOBALS['path_depth'] = 1;
require_once '../../config/database.php';

if (!isset($_SESSION['admin_id'])) {
    header("Location: ../super_login.php");
    exit;
}

// Ensure only Super Admin can access this page
if (($_SESSION['role'] ?? '') !== 'super') {
    header("Location: ../admin/dashboard.php");
    exit;
}

// Fetch Stats
$totalParticipants = $pdo->query("SELECT COUNT(*) FROM participants")->fetchColumn();
$totalGames = $pdo->query("SELECT COUNT(*) FROM games")->fetchColumn();
$totalPoints = $pdo->query("SELECT SUM(points) FROM participant_points")->fetchColumn();
$totalPoints = $totalPoints ? $totalPoints : 0;

// Count pending requests
$pendingRequestsCount = $pdo->query("SELECT COUNT(*) FROM profile_edit_requests WHERE status = 'pending'")->fetchColumn();

// Fetch Admins and Assigned Games
try {
    $adminsList = $pdo->query("
        SELECT a.username, a.role, g.game_name 
        FROM admins a 
        LEFT JOIN games g ON a.game_id = g.id 
        ORDER BY a.role DESC, a.username ASC
    ")->fetchAll();
} catch (PDOException $e) {
    // Fallback if column missing
    $adminsList = $pdo->query("SELECT username, role, NULL as game_name FROM admins ORDER BY role DESC, username ASC")->fetchAll();
    $dbError = "Database column 'game_id' missing in 'admins' table.";
}

include '../../views/header.php';
?>
<link rel="stylesheet" href="../css/admin_dashboard.css">
<div>
    <h2 class="mb-4">Super Admin Dashboard</h2>
    
    <?php if (isset($dbError)): ?>
        <div class="alert alert-danger shadow-soft">
            <h5 class="alert-heading">Database Update Required</h5>
            <p><?php echo $dbError; ?> Please run the fix script to resolve this.</p>
            <a href="fix_db.php" class="btn btn-light btn-sm fw-bold">Run Fix Script</a>
        </div>
    <?php endif; ?>

    <div class="row g-4 mb-5">
        <!-- Total Participants -->
        <div class="col-md-4">
            <div class="card stat-card bg-primary text-white shadow-soft">
                <div class="card-body d-flex justify-content-between align-items-center">
                    <div>
                        <h5 class="card-title">Participants</h5>
                        <h2 class="mb-0"><?php echo $totalParticipants; ?></h2>
                    </div>
                    <div class="stat-icon">👥</div>
                </div>
            </div>
        </div>

        <!-- Total Games -->
        <div class="col-md-4">
            <div class="card stat-card bg-success text-white shadow-soft">
                <div class="card-body d-flex justify-content-between align-items-center">
                    <div>
                        <h5 class="card-title">Games</h5>
                        <h2 class="mb-0"><?php echo $totalGames; ?></h2>
                    </div>
                    <div class="stat-icon">🎮</div>
                </div>
            </div>
        </div>

        <!-- Total Points Assigned -->
        <div class="col-md-4">
            <div class="card stat-card bg-purple text-white shadow-soft">
                <div class="card-body d-flex justify-content-between align-items-center">
                    <div>
                        <h5 class="card-title">Points Assigned</h5>
                        <h2 class="mb-0"><?php echo $totalPoints; ?></h2>
                    </div>
                    <div class="stat-icon">🏆</div>
                </div>
            </div>
        </div>
    </div>

    <h4 class="mb-3">System Management</h4>
    <div class="row g-4">
        <div class="col-md-3">
            <a href="manage_games.php" class="text-decoration-none">
                <div class="card shadow-soft p-4 text-center h-100 border-primary border-2">
                    <h4 class="text-primary">Manage Games</h4>
                    <p class="text-muted mb-0">Add, edit, or remove games from the event.</p>
                </div>
            </a>
        </div>
        <div class="col-md-3">
            <a href="logs.php" class="text-decoration-none">
                <div class="card shadow-soft p-4 text-center h-100 border-secondary border-2">
                    <h4 class="text-secondary">View Activity Logs</h4>
                    <p class="text-muted mb-0">Audit points assignment and admin actions.</p>
                </div>
            </a>
        </div>
        <div class="col-md-3">
            <a href="manage_admins.php" class="text-decoration-none">
                <div class="card shadow-soft p-4 text-center h-100 border-danger border-2">
                    <h4 class="text-danger">Manage Admins</h4>
                    <p class="text-muted mb-0">Create, edit, or remove admin accounts.</p>
                </div>
            </a>
        </div>
        <div class="col-md-3">
            <a href="manage_requests.php" class="text-decoration-none">
                <div class="card shadow-soft p-4 text-center h-100 border-warning border-2">
                    <h4 class="text-warning">Profile Requests</h4>
                    <p class="text-muted mb-0"><?php echo $pendingRequestsCount; ?> Pending Requests</p>
                </div>
            </a>
        </div>
        <div class="col-md-3">
            <a href="health_check.php" class="text-decoration-none">
                <div class="card shadow-soft p-4 text-center h-100 border-info border-2">
                    <h4 class="text-info">System Health</h4>
                    <p class="text-muted mb-0">Verify server status and database integrity.</p>
                </div>
            </a>
        </div>
        <div class="col-md-3">
            <a href="generate_dummy_data.php" class="text-decoration-none">
                <div class="card shadow-soft p-4 text-center h-100 border-warning border-2">
                    <h4 class="text-warning">Dummy Data</h4>
                    <p class="text-muted mb-0">Populate database with test participants and games.</p>
                </div>
            </a>
        </div>
        <div class="col-md-3">
            <a href="../reset_db.php" class="text-decoration-none">
                <div class="card shadow-soft p-4 text-center h-100 border-danger border-2">
                    <h4 class="text-danger">Reset Database</h4>
                    <p class="text-muted mb-0">Wipe all data and reset to default state.</p>
                </div>
            </a>
        </div>
    </div>

    <h4 class="mb-3 mt-5">Admin Overview</h4>
    <div class="card shadow-soft">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0 align-middle">
                    <thead class="table-light">
                        <tr>
                            <th class="ps-4">Username</th>
                            <th>Role</th>
                            <th>Assigned Game</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($adminsList as $admin): ?>
                        <tr>
                            <td class="ps-4 fw-bold"><?php echo htmlspecialchars($admin['username']); ?></td>
                            <td>
                                <?php if($admin['role'] === 'super'): ?>
                                    <span class="badge bg-danger">Super Admin</span>
                                <?php else: ?>
                                    <span class="badge bg-primary">Admin</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($admin['game_name']): ?>
                                    <span class="badge bg-info text-dark"><?php echo htmlspecialchars($admin['game_name']); ?></span>
                                <?php else: ?>
                                    <span class="text-muted small">None</span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php include '../../views/footer.php'; ?>