<?php
require_once '../config/database.php';

try {
    // Create the missing profile_edit_requests table
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS profile_edit_requests (
            id INT AUTO_INCREMENT PRIMARY KEY,
            participant_id INT NOT NULL,
            new_name VARCHAR(255),
            new_college VARCHAR(255),
            new_year VARCHAR(50),
            new_department VARCHAR(255),
            new_phone VARCHAR(20),
            status ENUM('pending', 'approved', 'rejected') DEFAULT 'pending',
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            FOREIGN KEY (participant_id) REFERENCES participants(id) ON DELETE CASCADE
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
    ");
    echo "Database updated successfully. Table 'profile_edit_requests' created.";

    // Add game_id to admins if not exists
    $colCheck = $pdo->query("SHOW COLUMNS FROM admins LIKE 'game_id'");
    if (!$colCheck->fetch()) {
        $pdo->exec("ALTER TABLE admins ADD COLUMN game_id INT DEFAULT NULL");
        $pdo->exec("ALTER TABLE admins ADD CONSTRAINT fk_admin_game FOREIGN KEY (game_id) REFERENCES games(id) ON DELETE SET NULL");
        echo "<br>Column 'game_id' added to 'admins' table.";
    }
} catch (PDOException $e) {
    echo "Error updating database: " . $e->getMessage();
}
?>