<?php
require_once '../config/database.php';

if (isset($_SESSION['admin_id'])) {
    header("Location: controller/dashboard.php");
    exit;
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';

    if (empty($username) || empty($password)) {
        $error = "Please enter both username and password.";
    } else {
        $stmt = $pdo->prepare("SELECT * FROM admins WHERE username = ? AND role = 'admin'");
        $stmt->execute([$username]);
        $admin = $stmt->fetch();

        if ($admin && password_verify($password, $admin['password_hash'])) {
            session_regenerate_id(true);
            $_SESSION['admin_id'] = $admin['id'];
            $_SESSION['role'] = $admin['role'];
            header("Location: controller/dashboard.php");
            exit;
        } else {
            $error = "Invalid credentials or unauthorized role.";
        }
    }
}
?>
<!DOCTYPE html>
<html class="dark" lang="en"><head>
<meta charset="utf-8"/>
<meta content="width=device-width, initial-scale=1.0" name="viewport"/>
<title>MAGMA Controller Login</title>
<link href="https://fonts.googleapis.com/css2?family=Spline+Sans:wght@300;400;500;600;700&amp;display=swap" rel="stylesheet"/>
<link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:wght,FILL@100..700,0..1&amp;display=swap" rel="stylesheet"/>
<script src="https://cdn.tailwindcss.com?plugins=forms,container-queries"></script>
<script id="tailwind-config">
        tailwind.config = {
            darkMode: "class",
            theme: {
                extend: {
                    colors: {
                        "primary": "#f9f506",
                        "background-light": "#f8f8f5",
                        "background-dark": "#1a1a1a", // Slightly lighter than pure black for depth
                        "card-glass": "rgba(35, 35, 16, 0.6)",
                    },
                    fontFamily: {
                        "display": ["Spline Sans", "sans-serif"]
                    },
                    borderRadius: {"DEFAULT": "1rem", "lg": "2rem", "xl": "3rem", "full": "9999px"},
                    backgroundImage: {
                        'magma-pattern': "url('https://images.unsplash.com/photo-1550684848-fac1c5b4e853?q=80&w=2070&auto=format&fit=crop')",
                    }
                },
            },
        }
    </script>
<link rel="stylesheet" href="css/game_login.css">
  </head>
<body class="font-display antialiased text-white bg-background-light dark:bg-background-dark min-h-screen flex flex-col relative overflow-hidden">
<!-- Background Image with Overlay -->
<div class="absolute inset-0 z-0">
<img alt="Background Pattern" class="w-full h-full object-cover opacity-40 mix-blend-overlay" data-alt="Abstract dark geometric shapes with subtle yellow glow" src="https://lh3.googleusercontent.com/aida-public/AB6AXuB5cYWR8O4Zm8y7Qftio3pK57O-soDDaItTED4KprPuroE5UeVGYmObse2MarnzQXP0tyC3UqN9OVFM9khJ9ptAUQDe0rYRcJXRepXugvtSFrHmPGtFJtAXVqK9ta6fAcvAB85H_94wx-xDuYE19h5X91qFIVMcTPndeuXZ7g7IbvGMC7PYh6LtImQPY8DWZZM7udXiuoJjd38b8aIGvy-6KrCqyNbA4iW9BMTAEl-VjWvOpO5DOawi5oanU10lyM5sLGLJIG7yIds"/>
<div class="absolute inset-0 bg-[#111105]/80 geo-overlay"></div>
</div>
<!-- Main Content Wrapper -->
<div class="relative z-10 flex-1 flex flex-col items-center justify-center p-6 w-full max-w-md mx-auto h-full">
<!-- Header Section -->
<div class="w-full text-center mb-8">
<div class="inline-flex items-center justify-center w-16 h-16 rounded-full bg-primary/20 mb-4 border border-primary/30 shadow-[0_0_15px_rgba(249,245,6,0.3)]">
<span class="material-symbols-outlined text-primary text-4xl">sports_esports</span>
</div>
<h1 class="text-primary tracking-widest text-[32px] font-bold leading-tight uppercase drop-shadow-md">MAGMA</h1>
<div class="h-1 w-24 bg-primary mx-auto my-2 rounded-full shadow-[0_0_10px_#f9f506]"></div>
<h2 class="text-white/80 text-sm font-bold tracking-[0.2em] uppercase">Controller Access</h2>
</div>
<!-- Glass Card Form -->
<div class="glass-panel w-full rounded-2xl p-8 shadow-2xl">
    <?php if ($error): ?>
        <div class="p-3 mb-6 text-sm text-red-400 bg-red-900/20 border border-red-500/30 rounded-lg text-center font-bold tracking-wide">
            <?php echo htmlspecialchars($error); ?>
        </div>
    <?php endif; ?>
<form method="POST" class="flex flex-col gap-6">
<!-- Username Field -->
<div class="flex flex-col gap-2">
<label class="text-white/90 text-sm font-bold uppercase tracking-wider pl-2">Username</label>
<div class="relative group">
<div class="absolute inset-y-0 left-0 flex items-center pl-4 pointer-events-none text-primary/70">
<span class="material-symbols-outlined text-[20px]">person</span>
</div>
<input class="form-input w-full bg-black/40 border border-white/10 text-white placeholder-white/30 rounded-full h-14 pl-12 pr-4 focus:border-primary focus:ring-1 focus:ring-primary focus:outline-none transition-all duration-300 backdrop-blur-sm" placeholder="Agent ID" type="text" name="username" required autofocus/>
</div>
</div>
<!-- Password Field -->
<div class="flex flex-col gap-2">
<label class="text-white/90 text-sm font-bold uppercase tracking-wider pl-2">Password</label>
<div class="relative group">
<div class="absolute inset-y-0 left-0 flex items-center pl-4 pointer-events-none text-primary/70">
<span class="material-symbols-outlined text-[20px]">key</span>
</div>
<input class="form-input w-full bg-black/40 border border-white/10 text-white placeholder-white/30 rounded-full h-14 pl-12 pr-12 focus:border-primary focus:ring-1 focus:ring-primary focus:outline-none transition-all duration-300 backdrop-blur-sm" placeholder="Access Code" type="password" name="password" id="password" required/>
<button type="button" class="absolute inset-y-0 right-0 flex items-center pr-4 text-white/50 hover:text-primary transition-colors cursor-pointer focus:outline-none" onclick="const p = document.getElementById('password'); p.type = p.type === 'password' ? 'text' : 'password';">
<span class="material-symbols-outlined text-[20px]">visibility</span>
</button>
</div>
</div>
<!-- Login Button -->
<button type="submit" class="w-full bg-primary hover:bg-[#d4d105] text-[#232310] h-14 rounded-full font-bold text-lg tracking-widest uppercase shadow-[0_0_20px_rgba(249,245,6,0.4)] hover:shadow-[0_0_30px_rgba(249,245,6,0.6)] active:scale-[0.98] transition-all duration-200 mt-4 flex items-center justify-center gap-2 group">
<span>Initialize</span>
<span class="material-symbols-outlined group-hover:translate-x-1 transition-transform">arrow_forward</span>
</button>
</form>
<!-- Footer Links -->
<div class="flex justify-between items-center mt-2 px-2 text-xs font-medium tracking-wide text-white/50">
<a class="hover:text-primary transition-colors" href="#">FORGOT CODE?</a>
<a class="hover:text-primary transition-colors" href="#">HELP CENTER</a>
</div>
</div>
<!-- Bottom Status -->
<div class="mt-8 flex items-center justify-center gap-2 text-white/30 text-xs uppercase tracking-widest">
<div class="w-2 h-2 rounded-full bg-green-500 animate-pulse shadow-[0_0_8px_rgba(34,197,94,0.8)]"></div>
            Server Online v2.4
        </div>
</div>
</body></html>