<?php
require_once '../config/database.php';
header('Content-Type: application/json');

$game_id = filter_input(INPUT_GET, 'game_id', FILTER_VALIDATE_INT);

if (!$game_id) {
    echo json_encode(['count' => 0]);
    exit;
}

try {
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM admin_logs WHERE game_id = ? AND DATE(created_at) = CURDATE()");
    $stmt->execute([$game_id]);
    $count = $stmt->fetchColumn();
    echo json_encode(['count' => $count]);
} catch (PDOException $e) {
    echo json_encode(['count' => 0]);
}
?>