<?php
$GLOBALS['path_depth'] = 1;
require_once '../../config/database.php';

// Ensure user is logged in and is a super_admin
if (!isset($_SESSION['admin_id']) || ($_SESSION['role'] ?? '') !== 'super') {
    header("Location: ../super_login.php");
    exit;
}

$logs = [];
$error = '';

try {
    // Attempt to fetch logs. Assumes a system_logs table exists.
    // If you haven't created this table yet, run:
    // CREATE TABLE system_logs (id INT AUTO_INCREMENT PRIMARY KEY, admin_id INT, action VARCHAR(50), details TEXT, ip_address VARCHAR(45), created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP);
    $sql = "SELECT l.*, a.username, p.name as participant_name, g.game_name 
            FROM admin_logs l 
            LEFT JOIN admins a ON l.admin_id = a.id 
            LEFT JOIN participants p ON l.participant_id = p.id
            LEFT JOIN games g ON l.game_id = g.id
            ORDER BY l.created_at DESC 
            LIMIT 100";
    $logs = $pdo->query($sql)->fetchAll();
} catch (PDOException $e) {
    // Gracefully handle missing table
    $error = "Logs are currently unavailable. Error: " . $e->getMessage();
}

include '../../views/header.php';
?>
<link rel="stylesheet" href="../css/admin_dashboard.css">

<div class="container">
    <h2 class="mb-4">System Logs</h2>
    
    <?php if ($error): ?>
        <div class="alert alert-warning"><?php echo htmlspecialchars($error); ?></div>
    <?php endif; ?>

    <div class="card shadow-soft">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead class="table-light">
                        <tr>
                            <th>Time</th>
                            <th>User</th>
                            <th>Activity</th>
                            <th>Note</th>
                            <th>IP</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($logs as $log): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($log['created_at']); ?></td>
                            <td><?php echo htmlspecialchars($log['username'] ?? 'System'); ?></td>
                            <td>
                                Assigned <strong><?php echo htmlspecialchars($log['points_given']); ?> pts</strong>
                                to <?php echo htmlspecialchars($log['participant_name']); ?>
                                for <?php echo htmlspecialchars($log['game_name']); ?>
                            </td>
                            <td><?php echo htmlspecialchars($log['note'] ?? '-'); ?></td>
                            <td><?php echo htmlspecialchars($log['ip'] ?? ''); ?></td>
                        </tr>
                        <?php endforeach; ?>
                        <?php if (empty($logs) && !$error): ?>
                            <tr><td colspan="5" class="text-center text-muted py-4">No logs found.</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php include '../../views/footer.php'; ?>