<?php
require_once '../config/database.php';

$search = trim($_GET['search'] ?? '');
$params = [];

// Fetch participants with total points
$sql = "SELECT p.name, p.college, p.department, COALESCE(SUM(pp.points), 0) as total_points 
        FROM participants p 
        LEFT JOIN participant_points pp ON p.id = pp.participant_id";

if (!empty($search)) {
    $sql .= " WHERE p.name LIKE ?";
    $params[] = "%$search%";
}

$sql .= " GROUP BY p.id ORDER BY total_points DESC, p.name ASC";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$participants = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html class="dark" lang="en"><head>
<meta charset="utf-8"/>
<meta content="width=device-width, initial-scale=1.0" name="viewport"/>
<title>MAGMA 2025 Leaderboard</title>
<link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;700;800;900&display=swap" rel="stylesheet"/>
<link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:wght,FILL@100..700,0..1&display=swap" rel="stylesheet"/>
<script src="https://cdn.tailwindcss.com?plugins=forms,container-queries"></script>
<script id="tailwind-config">
        tailwind.config = {
            darkMode: "class",
            theme: {
                extend: {
                    colors: {
                        "primary-accent": "#FF00FF", // Magenta
                        "secondary-accent": "#FF5F1F", // Electric Orange
                        "background-dark": "#050505",
                        "text-light": "#ffffff",
                        "text-dark": "#0a0a0a",
                        "placeholder-color": "#666666",
                        "input-bg-dark": "#121212",
                        "input-border-dark": "#2a2a2a",
                        "surface-dark": "#0f0f0f",
                    },
                    fontFamily: {
                        "display": ["Montserrat", "sans-serif"]
                    },
                    borderRadius: {
                        "DEFAULT": "0.5rem",
                        "lg": "1rem",
                        "xl": "1rem",
                        "2xl": "1.5rem",
                        "full": "9999px"
                    },
                },
            },
        }
    </script>
<link rel="stylesheet" href="css/ranking.css">
  </head>
<body class="bg-background-dark text-text-light font-display">
<div class="fixed inset-0 bg-pattern"></div>
<div class="fixed inset-0 noise-overlay"></div>
<div class="fixed top-[-10%] right-[-10%] w-[400px] h-[400px] bg-primary-accent rounded-full blur-[130px] opacity-20 pointer-events-none animate-pulse"></div>
<div class="fixed bottom-[5%] left-[-15%] w-[350px] h-[350px] bg-secondary-accent rounded-full blur-[100px] opacity-15 pointer-events-none mix-blend-screen"></div>
<div class="relative flex h-full min-h-screen w-full flex-col overflow-x-hidden z-10">
<div class="flex-1 flex flex-col items-center px-4 py-6 w-full max-w-lg mx-auto">
<div class="w-full flex flex-row items-center justify-between mb-8 relative z-20">
<div class="flex items-center space-x-4">
<div class="relative group">
<div class="absolute inset-0 bg-secondary-accent blur-lg opacity-40 rounded-full group-hover:opacity-60 transition-opacity duration-300"></div>
<div class="relative w-12 h-12 bg-gradient-to-br from-primary-accent to-purple-900 rounded-xl -rotate-6 flex items-center justify-center shadow-lg border border-white/20">
<span class="material-symbols-outlined text-2xl text-white drop-shadow-md">emoji_events</span>
</div>
</div>
<div>
<h1 class="text-white tracking-tighter text-2xl font-black leading-none italic uppercase drop-shadow-lg transform -skew-x-6">
                            MAGMA<span class="text-secondary-accent">.</span>25
                        </h1>
<p class="text-primary-accent text-[10px] font-bold tracking-[0.2em] mt-1 uppercase text-glow">
                            Leaderboard
                        </p>
</div>
</div>
<div class="w-10 h-10 rounded-full bg-white/5 border border-white/10 flex items-center justify-center backdrop-blur-sm">
<span class="material-symbols-outlined text-gray-400">person</span>
</div>
</div>
<form method="GET" action="ranking.php" class="w-full mb-6 group input-glow transition-all duration-300 rounded-xl">
<label class="sr-only" for="search">Search</label>
<div class="relative flex items-center h-12 bg-input-bg-dark/80 backdrop-blur-md rounded-xl border border-input-border-dark group-focus-within:border-primary-accent transition-colors shadow-lg">
<div class="w-12 h-full flex items-center justify-center">
<span class="material-symbols-outlined text-gray-500 group-focus-within:text-primary-accent transition-colors text-xl">search</span>
</div>
<input class="form-input flex w-full bg-transparent text-white border-none h-full placeholder:text-gray-600 px-2 text-sm font-bold tracking-wide focus:outline-0 focus:ring-0" id="search" name="search" placeholder="Search by name..." type="text" value="<?php echo htmlspecialchars($search); ?>"/>
</div>
</form>
<div class="w-full flex-1 flex flex-col backdrop-blur-md bg-surface-dark/60 rounded-2xl border border-white/10 shadow-2xl relative overflow-hidden">
<div class="absolute top-0 left-0 w-full h-[2px] bg-gradient-to-r from-secondary-accent via-primary-accent to-secondary-accent opacity-70"></div>
<div class="bg-white/5 border-b border-white/5">
<div class="grid grid-cols-12 gap-2 px-4 py-3 text-xs font-extrabold text-gray-400 uppercase tracking-wider">
<div class="col-span-2 text-center">Rank</div>
<div class="col-span-6">Participant</div>
<div class="col-span-4 text-right">Points</div>
</div>
</div>
<div class="overflow-y-auto custom-scrollbar flex-1 relative">
<?php 
$rank = 1;
foreach ($participants as $p): 
    $isTop1 = $rank === 1;
    $isTop2 = $rank === 2;
    $isTop3 = $rank === 3;
    
    $barColor = $isTop1 ? 'bg-yellow-400 shadow-[0_0_15px_rgba(250,204,21,0.5)]' : 
                ($isTop2 ? 'bg-gray-300 shadow-[0_0_10px_rgba(209,213,219,0.3)]' : 
                ($isTop3 ? 'bg-amber-600 shadow-[0_0_10px_rgba(217,119,6,0.3)]' : ''));
    
    $iconColor = $isTop1 ? 'text-yellow-400 drop-shadow-[0_0_8px_rgba(250,204,21,0.6)]' : 
                 ($isTop2 ? 'text-gray-300 drop-shadow-md' : 
                 ($isTop3 ? 'text-amber-600 drop-shadow-md' : ''));
                 
    $pointsColor = $isTop1 ? 'text-yellow-400 text-glow-orange' : 
                   ($isTop2 ? 'text-gray-300' : 
                   ($isTop3 ? 'text-amber-600' : 'text-white'));
?>
<div class="group relative border-b border-white/5 hover:bg-white/5 transition-colors duration-200">
<?php if ($rank <= 3): ?>
<div class="absolute left-0 top-0 bottom-0 w-1 <?php echo $barColor; ?>"></div>
<?php endif; ?>
<div class="grid grid-cols-12 gap-2 px-4 py-4 items-center">
<div class="col-span-2 flex justify-center">
<?php if ($rank <= 3): ?>
<div class="relative w-8 h-8 flex items-center justify-center">
<span class="material-symbols-outlined <?php echo $iconColor; ?> text-3xl absolute">workspace_premium</span>
<span class="text-[10px] font-black text-black z-10 mt-1"><?php echo $rank; ?></span>
</div>
<?php else: ?>
<span class="text-gray-500 font-black text-sm font-display"><?php echo str_pad($rank, 2, '0', STR_PAD_LEFT); ?></span>
<?php endif; ?>
</div>
<div class="col-span-6 flex flex-col justify-center">
<span class="<?php echo $rank <= 3 ? 'text-white' : 'text-gray-200'; ?> font-bold text-sm tracking-wide truncate"><?php echo htmlspecialchars($p['name']); ?></span>
<div class="flex items-center space-x-1 mt-0.5 overflow-x-auto no-scrollbar">
<span class="text-[10px] text-gray-400 font-bold uppercase whitespace-nowrap"><?php echo htmlspecialchars($p['college']); ?></span>
<span class="text-[10px] text-gray-600">•</span>
<span class="text-[10px] <?php echo $rank <= 3 ? 'text-primary-accent' : 'text-gray-500'; ?> font-bold uppercase whitespace-nowrap"><?php echo htmlspecialchars($p['department']); ?></span>
</div>
</div>
<div class="col-span-4 text-right">
<span class="<?php echo $pointsColor; ?> font-black <?php echo $rank <= 3 ? 'text-lg' : 'text-base'; ?>"><?php echo number_format($p['total_points']); ?></span>
<?php if ($rank <= 3): ?>
<span class="text-[9px] text-gray-500 block uppercase font-bold tracking-widest">PTS</span>
<?php endif; ?>
</div>
</div>
</div>
<?php 
$rank++;
endforeach; 
?>
<?php if (count($participants) === 0): ?>
<div class="p-8 text-center text-gray-500 text-sm font-bold uppercase tracking-wider">
    No participants found
</div>
<?php endif; ?>
</div>
<div class="absolute bottom-0 left-0 w-full h-8 bg-gradient-to-t from-surface-dark to-transparent pointer-events-none"></div>
</div>
<?php if (isset($_SESSION['unique_id'])): ?>
    <!-- User's own rank logic would go here if we fetched it separately or found it in the list -->
<?php endif; ?>
</div>
</div>
</div>

</body></html>