<?php
// public/register.php

require_once '../config/database.php';

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $college = trim($_POST['college'] ?? '');
    $year = trim($_POST['year'] ?? '');
    $department = trim($_POST['department'] ?? '');
    $phone = trim($_POST['phone'] ?? '');
    $password = $_POST['password'] ?? '';

    // Validation
    if (empty($name) || empty($college) || empty($year) || empty($department) || empty($phone) || empty($password)) {
        $error = "All fields are required.";
    } elseif (!ctype_digit($phone)) {
        $error = "Phone number must contain digits only.";
    } elseif (strlen($password) < 6) {
        $error = "Password must be at least 6 characters.";
    } else {
        // Generate Unique ID: Random 4 alphanumeric characters (Ensure uniqueness)
        do {
            $unique_id = substr(str_shuffle("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, 4);
            $checkStmt = $pdo->prepare("SELECT id FROM participants WHERE unique_id = ?");
            $checkStmt->execute([$unique_id]);
        } while ($checkStmt->fetch());
        
        // Hash Password
        $password_hash = password_hash($password, PASSWORD_DEFAULT);

        try {
            $stmt = $pdo->prepare("INSERT INTO participants (unique_id, name, college, year, department, phone, password_hash) VALUES (?, ?, ?, ?, ?, ?, ?)");
            $stmt->execute([$unique_id, $name, $college, $year, $department, $phone, $password_hash]);

            // Set session and redirect
            $_SESSION['unique_id'] = $unique_id;
            header("Location: participant/profile.php");
            exit;
        } catch (PDOException $e) {
            if ($e->getCode() == 23000) { // Duplicate entry
                $error = "Registration failed. Please try again.";
            } else {
                $error = "Database error: " . $e->getMessage();
            }
        }
    }
}

?>
<!DOCTYPE html>
<html class="dark" lang="en"><head>
<meta charset="utf-8"/>
<meta content="width=device-width, initial-scale=1.0" name="viewport"/>
<title>MAGMA 2025 Student Registration</title>
<link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;700;800;900&display=swap" rel="stylesheet"/>
<link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:wght,FILL@100..700,0..1&display=swap" rel="stylesheet"/>
<script src="https://cdn.tailwindcss.com?plugins=forms,container-queries"></script>
<script id="tailwind-config">
        tailwind.config = {
            darkMode: "class",
            theme: {
                extend: {
                    colors: {
                        "primary-accent": "#FF00FF", // Magenta
                        "secondary-accent": "#FF5F1F", // Electric Orange
                        "background-dark": "#050505",
                        "text-light": "#ffffff",
                        "text-dark": "#0a0a0a",
                        "placeholder-color": "#666666",
                        "input-bg-dark": "#121212",
                        "input-border-dark": "#2a2a2a",
                        "surface-dark": "#0f0f0f",
                    },
                    fontFamily: {
                        "display": ["Montserrat", "sans-serif"]
                    },
                    borderRadius: {
                        "DEFAULT": "0.5rem",
                        "lg": "1rem",
                        "xl": "1rem",
                        "2xl": "1.5rem",
                        "full": "9999px"
                    },
                    animation: {
                        'fade-in-up': 'fadeInUp 0.8s ease-out forwards',
                        'slide-in': 'slideIn 0.5s ease-out forwards',
                    },
                    keyframes: {
                        fadeInUp: {
                            '0%': { opacity: '0', transform: 'translateY(20px)' },
                            '100%': { opacity: '1', transform: 'translateY(0)' },
                        },
                        slideIn: {
                            '0%': { opacity: '0', transform: 'translateX(-20px)' },
                            '100%': { opacity: '1', transform: 'translateX(0)' },
                        }
                    }
                },
            },
        }
    </script>
<link rel="stylesheet" href="css/register.css">
  </head>
<body class="bg-background-dark text-text-light font-display">
<div class="fixed inset-0 bg-pattern"></div>
<div class="fixed inset-0 noise-overlay"></div>
<div class="fixed top-[-10%] right-[-10%] w-[400px] h-[400px] bg-primary-accent rounded-full blur-[130px] opacity-20 pointer-events-none animate-pulse"></div>
<div class="fixed bottom-[5%] left-[-15%] w-[350px] h-[350px] bg-secondary-accent rounded-full blur-[100px] opacity-15 pointer-events-none mix-blend-screen"></div>
<div class="relative flex h-full min-h-screen w-full flex-col overflow-x-hidden z-10">
<div class="flex-1 flex flex-col items-center justify-center px-5 py-6 w-full max-w-lg mx-auto animate-fade-in-up">
<div class="w-full flex flex-col items-center mb-8 relative group">
<div class="relative mb-4">
<div class="absolute inset-0 bg-secondary-accent blur-xl opacity-30 rounded-full scale-110 group-hover:scale-125 transition-transform duration-500"></div>
<div class="relative w-20 h-20 bg-gradient-to-br from-primary-accent to-purple-800 rounded-2xl -rotate-3 flex items-center justify-center shadow-xl border border-white/10 z-10">
<span class="material-symbols-outlined text-4xl text-white drop-shadow-md rotate-3">how_to_reg</span>
</div>
</div>
<h1 class="text-white tracking-tighter text-5xl font-black leading-none text-center italic uppercase drop-shadow-lg text-glow transform -skew-x-6">
                MAGMA<span class="text-secondary-accent">.</span>25
            </h1>
<div class="h-1 w-16 bg-gradient-to-r from-transparent via-secondary-accent to-transparent mt-3 mb-2"></div>
<p class="text-gray-400 text-xs font-bold tracking-[0.3em] mt-1 text-center uppercase">
                Student Registration
            </p>
</div>
<form method="POST" action="register.php" class="w-full space-y-4 backdrop-blur-md bg-surface-dark/70 p-6 rounded-2xl border border-white/10 shadow-2xl relative overflow-hidden">
<?php if ($error): ?>
    <div class="p-3 mb-4 text-sm text-red-500 bg-red-100/10 border border-red-500/50 rounded-lg">
        <?php echo htmlspecialchars($error); ?>
    </div>
<?php endif; ?>
<div class="absolute top-0 left-0 w-full h-[2px] bg-gradient-to-r from-transparent via-primary-accent to-transparent opacity-50"></div>
<div class="flex w-full flex-col group input-glow transition-all duration-300 rounded-xl animate-slide-in" style="animation-delay: 100ms; opacity: 0;">
<label class="sr-only" for="name">Full Name</label>
<div class="relative flex items-center h-12 bg-input-bg-dark rounded-xl border border-input-border-dark group-focus-within:border-primary-accent transition-colors">
<div class="w-12 h-full flex items-center justify-center bg-white/5 border-r border-white/5 rounded-l-xl">
<span class="material-symbols-outlined text-gray-500 group-focus-within:text-primary-accent transition-colors text-xl">person</span>
</div>
<input class="form-input flex w-full bg-transparent text-white border-none h-full placeholder:text-gray-600 px-4 text-sm font-bold tracking-wide focus:outline-0 focus:ring-0" id="name" name="name" placeholder="FULL NAME" type="text" value="<?php echo htmlspecialchars($_POST['name'] ?? ''); ?>" required/>
</div>
</div>
<div class="flex w-full flex-col group input-glow transition-all duration-300 rounded-xl animate-slide-in" style="animation-delay: 150ms; opacity: 0;">
<label class="sr-only" for="college">College Name</label>
<div class="relative flex items-center h-12 bg-input-bg-dark rounded-xl border border-input-border-dark group-focus-within:border-secondary-accent transition-colors">
<div class="w-12 h-full flex items-center justify-center bg-white/5 border-r border-white/5 rounded-l-xl">
<span class="material-symbols-outlined text-gray-500 group-focus-within:text-secondary-accent transition-colors text-xl">school</span>
</div>
<input class="form-input flex w-full bg-transparent text-white border-none h-full placeholder:text-gray-600 px-4 text-sm font-bold tracking-wide focus:outline-0 focus:ring-0" id="college" name="college" placeholder="COLLEGE NAME" type="text" value="<?php echo htmlspecialchars($_POST['college'] ?? ''); ?>" required/>
</div>
</div>
<div class="flex flex-row space-x-3">
<div class="flex w-2/5 flex-col group input-glow transition-all duration-300 rounded-xl animate-slide-in" style="animation-delay: 200ms; opacity: 0;">
<label class="sr-only" for="year">Year</label>
<div class="relative flex items-center h-12 bg-input-bg-dark rounded-xl border border-input-border-dark group-focus-within:border-primary-accent transition-colors">
<div class="absolute left-3 flex items-center pointer-events-none">
<span class="text-gray-500 font-bold text-xs mr-1">YR</span>
</div>
<select class="form-select w-full bg-transparent text-white border-none h-full pl-10 pr-8 text-sm font-bold tracking-wide focus:outline-0 focus:ring-0 appearance-none cursor-pointer" id="year" name="year" required>
<option class="text-gray-500" disabled="" selected="" value="">SELECT</option>
<option class="text-black" value="1" <?php echo (($_POST['year'] ?? '') == '1') ? 'selected' : ''; ?>>1</option>
<option class="text-black" value="2" <?php echo (($_POST['year'] ?? '') == '2') ? 'selected' : ''; ?>>2</option>
<option class="text-black" value="3" <?php echo (($_POST['year'] ?? '') == '3') ? 'selected' : ''; ?>>3</option>
<option class="text-black" value="4" <?php echo (($_POST['year'] ?? '') == '4') ? 'selected' : ''; ?>>4</option>
<option class="text-black" value="4" <?php echo (($_POST['year'] ?? '') == '5') ? 'selected' : ''; ?>>other</option>
</select>
<div class="absolute right-2 pointer-events-none flex items-center">
<span class="material-symbols-outlined text-gray-500 text-sm">expand_more</span>
</div>
</div>
</div>
<div class="flex w-3/5 flex-col group input-glow transition-all duration-300 rounded-xl animate-slide-in" style="animation-delay: 250ms; opacity: 0;">
<label class="sr-only" for="department">Department</label>
<div class="relative flex items-center h-12 bg-input-bg-dark rounded-xl border border-input-border-dark group-focus-within:border-primary-accent transition-colors">
<div class="w-10 h-full flex items-center justify-center bg-white/5 border-r border-white/5 rounded-l-xl">
<span class="material-symbols-outlined text-gray-500 group-focus-within:text-primary-accent transition-colors text-lg">domain</span>
</div>
<input class="form-input flex w-full bg-transparent text-white border-none h-full placeholder:text-gray-600 px-3 text-sm font-bold tracking-wide focus:outline-0 focus:ring-0" id="department" name="department" placeholder="DEPT" type="text" value="<?php echo htmlspecialchars($_POST['department'] ?? ''); ?>" required/>
</div>
</div>
</div>
<div class="flex w-full flex-col group input-glow transition-all duration-300 rounded-xl animate-slide-in" style="animation-delay: 300ms; opacity: 0;">
<label class="sr-only" for="phone">Phone Number</label>
<div class="relative flex items-center h-12 bg-input-bg-dark rounded-xl border border-input-border-dark group-focus-within:border-secondary-accent transition-colors">
<div class="w-12 h-full flex items-center justify-center bg-white/5 border-r border-white/5 rounded-l-xl">
<span class="material-symbols-outlined text-gray-500 group-focus-within:text-secondary-accent transition-colors text-xl">call</span>
</div>
<input class="form-input flex w-full bg-transparent text-white border-none h-full placeholder:text-gray-600 px-4 text-sm font-bold tracking-wide focus:outline-0 focus:ring-0" id="phone" name="phone" placeholder="PHONE NUMBER" type="tel" value="<?php echo htmlspecialchars($_POST['phone'] ?? ''); ?>" required/>
</div>
</div>
<div class="flex w-full flex-col group input-glow transition-all duration-300 rounded-xl animate-slide-in" style="animation-delay: 350ms; opacity: 0;">
<label class="sr-only" for="password">Password</label>
<div class="relative flex items-center h-12 bg-input-bg-dark rounded-xl border border-input-border-dark group-focus-within:border-primary-accent transition-colors">
<div class="w-12 h-full flex items-center justify-center bg-white/5 border-r border-white/5 rounded-l-xl">
<span class="material-symbols-outlined text-gray-500 group-focus-within:text-primary-accent transition-colors text-xl">lock</span>
</div>
<input class="form-input flex w-full bg-transparent text-white border-none h-full placeholder:text-gray-600 px-4 text-sm font-bold tracking-wide focus:outline-0 focus:ring-0" id="password" name="password" placeholder="PASSWORD" type="password" required/>
<button class="absolute right-0 top-0 bottom-0 w-12 flex items-center justify-center text-gray-500 hover:text-white transition-colors" type="button" onclick="const p = document.getElementById('password'); p.type = p.type === 'password' ? 'text' : 'password';">
<span class="material-symbols-outlined text-xl">visibility_off</span>
</button>
</div>
</div>
<button type="submit" class="relative w-full group cursor-pointer h-14 mt-2 overflow-hidden rounded-xl bg-gradient-to-r from-primary-accent to-purple-600 transition-all duration-300 hover:shadow-[0_0_30px_rgba(255,0,255,0.4)] active:scale-[0.98] border border-white/10 animate-slide-in" style="animation-delay: 400ms; opacity: 0;">
<div class="absolute inset-0 bg-white/20 translate-y-full group-hover:translate-y-0 transition-transform duration-500 ease-out"></div>
<div class="flex items-center justify-center h-full w-full relative z-10">
<span class="text-white text-lg font-black uppercase tracking-widest mr-2">Register</span>
<span class="material-symbols-outlined text-white font-bold group-hover:translate-x-1 transition-transform">arrow_forward</span>
</div>
</button>
</form>
<div class="w-full py-6 text-center z-10">
<p class="text-gray-500 text-xs font-bold uppercase tracking-wide mb-2">
                Already have an account?
            </p>
<a class="inline-flex items-center text-secondary-accent text-sm font-black uppercase tracking-wider hover:text-white transition-colors group border-b-2 border-transparent hover:border-secondary-accent pb-1" href="login.php">
                Login Here
                <span class="material-symbols-outlined text-base ml-1 group-hover:translate-x-1 transition-transform">login</span>
</a>
</div>
</div>
</div>
</body></html>
