<?php
$GLOBALS['path_depth'] = 1;
require_once '../../config/database.php';

// Ensure user is logged in and is a super_admin
if (!isset($_SESSION['admin_id']) || ($_SESSION['role'] ?? '') !== 'super') {
    header("Location: ../admin_login.php");
    exit;
}

// Fetch Stats
$totalParticipants = $pdo->query("SELECT COUNT(*) FROM participants")->fetchColumn();
$totalGames = $pdo->query("SELECT COUNT(*) FROM games")->fetchColumn();
$totalPoints = $pdo->query("SELECT SUM(points) FROM participant_points")->fetchColumn();
$totalPoints = $totalPoints ? $totalPoints : 0;

// Count pending requests
$pendingRequestsCount = $pdo->query("SELECT COUNT(*) FROM profile_edit_requests WHERE status = 'pending'")->fetchColumn();

// Fetch Recent Activity (Points Assignment)
$logs = $pdo->query("
    SELECT l.*, a.username, p.name as participant_name, g.game_name
    FROM admin_logs l 
    LEFT JOIN admins a ON l.admin_id = a.id 
    LEFT JOIN participants p ON l.participant_id = p.id
    LEFT JOIN games g ON l.game_id = g.id
    ORDER BY l.created_at DESC 
    LIMIT 5
")->fetchAll();
?>
<!DOCTYPE html>
<html class="dark" lang="en">
<head>
    <meta charset="utf-8"/>
    <meta content="width=device-width, initial-scale=1.0" name="viewport"/>
    <title>MAGMA Super Admin Dashboard</title>
    <link href="https://fonts.googleapis.com/css2?family=Spline+Sans:wght@300;400;500;600;700&display=swap" rel="stylesheet"/>
    <link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:wght,FILL@100..700,0..1&display=swap" rel="stylesheet"/>
    <script src="https://cdn.tailwindcss.com?plugins=forms,container-queries"></script>
    <script>
        tailwind.config = {
            darkMode: "class",
            theme: {
                extend: {
                    colors: {
                        "primary": "#ff1a1a",
                        "background-dark": "#1a1a1a",
                        "surface-dark": "#121212",
                    },
                    fontFamily: {
                        "display": ["Spline Sans", "sans-serif"]
                    }
                },
            },
        }
    </script>
    <link rel="stylesheet" href="../css/admin_dashboard.css">
</head>
<body class="bg-background-dark text-white font-display flex h-screen overflow-hidden">
    
    <!-- Sidebar -->
    <aside class="w-64 bg-surface-dark border-r border-white/5 flex flex-col z-20 hidden md:flex">
        <div class="p-6 flex items-center gap-3 border-b border-white/5">
            <div class="w-10 h-10 rounded-lg bg-primary/20 flex items-center justify-center border border-primary/30">
                <span class="material-symbols-outlined text-primary">admin_panel_settings</span>
            </div>
            <div>
                <h1 class="font-bold text-lg tracking-wider">MAGMA</h1>
                <p class="text-[10px] text-gray-500 uppercase tracking-widest font-bold">Super Admin</p>
            </div>
        </div>
        
        <nav class="flex-1 py-6 space-y-1">
            <a href="dashboard.php" class="sidebar-link active flex items-center gap-3 px-6 py-3 text-sm font-medium text-gray-300">
                <span class="material-symbols-outlined">dashboard</span>
                Dashboard
            </a>
            <a href="controllers.php" class="sidebar-link flex items-center gap-3 px-6 py-3 text-sm font-medium text-gray-300">
                <span class="material-symbols-outlined">sports_esports</span>
                Manage Controllers
            </a>
            <a href="games.php" class="sidebar-link flex items-center gap-3 px-6 py-3 text-sm font-medium text-gray-300">
                <span class="material-symbols-outlined">videogame_asset</span>
                Games & Scoring
            </a>
            <a href="participants.php" class="sidebar-link flex items-center gap-3 px-6 py-3 text-sm font-medium text-gray-300">
                <span class="material-symbols-outlined">groups</span>
                Participants
            </a>
            <a href="requests.php" class="sidebar-link flex items-center gap-3 px-6 py-3 text-sm font-medium text-gray-300">
                <span class="material-symbols-outlined">pending_actions</span>
                Requests
            </a>
            <a href="logs.php" class="sidebar-link flex items-center gap-3 px-6 py-3 text-sm font-medium text-gray-300">
                <span class="material-symbols-outlined">receipt_long</span>
                System Logs
            </a>
        </nav>

        <div class="p-4 border-t border-white/5">
            <a href="logout.php" class="flex items-center gap-3 px-4 py-3 text-sm font-medium text-red-400 hover:bg-red-500/10 rounded-lg transition-colors">
                <span class="material-symbols-outlined">logout</span>
                Sign Out
            </a>
        </div>
    </aside>

    <!-- Main Content -->
    <main class="flex-1 flex flex-col relative overflow-hidden">
        <div class="absolute inset-0 geo-overlay z-0"></div>
        
        <!-- Mobile Header -->
        <header class="md:hidden h-16 border-b border-white/5 flex items-center justify-between px-4 bg-surface-dark z-20">
            <div class="flex items-center gap-2">
                <span class="material-symbols-outlined text-primary">admin_panel_settings</span>
                <span class="font-bold tracking-wider">MAGMA</span>
            </div>
            <button class="text-gray-400 hover:text-white">
                <span class="material-symbols-outlined">menu</span>
            </button>
        </header>

        <div class="flex-1 overflow-y-auto p-6 md:p-10 relative z-10 custom-scrollbar">
            <div class="max-w-7xl mx-auto">
                <div class="flex items-end justify-between mb-8">
                    <div>
                        <h2 class="text-3xl font-bold text-white mb-1">Dashboard Overview</h2>
                        <p class="text-gray-500 text-sm">Welcome back, Super Admin.</p>
                    </div>
                    <div class="flex gap-3">
                         <a href="../generate_dummy_data.php" class="bg-white/5 hover:bg-white/10 border border-white/10 text-gray-300 px-4 py-2 rounded-lg font-bold text-xs uppercase tracking-wider flex items-center gap-2 transition-colors">
                            <span class="material-symbols-outlined text-sm">database</span>
                            Gen Data
                        </a>
                    </div>
                </div>

                <!-- Stats Grid -->
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
                    <!-- Participants -->
                    <div class="glass-panel p-6 rounded-2xl border border-white/10 relative overflow-hidden group">
                        <div class="absolute right-0 top-0 p-4 opacity-10 group-hover:opacity-20 transition-opacity">
                            <span class="material-symbols-outlined text-6xl">groups</span>
                        </div>
                        <p class="text-gray-500 text-xs font-bold uppercase tracking-wider mb-1">Total Participants</p>
                        <h3 class="text-3xl font-black text-white"><?php echo number_format($totalParticipants); ?></h3>
                    </div>

                    <!-- Games -->
                    <div class="glass-panel p-6 rounded-2xl border border-white/10 relative overflow-hidden group">
                        <div class="absolute right-0 top-0 p-4 opacity-10 group-hover:opacity-20 transition-opacity">
                            <span class="material-symbols-outlined text-6xl">videogame_asset</span>
                        </div>
                        <p class="text-gray-500 text-xs font-bold uppercase tracking-wider mb-1">Active Games</p>
                        <h3 class="text-3xl font-black text-white"><?php echo number_format($totalGames); ?></h3>
                    </div>

                    <!-- Points -->
                    <div class="glass-panel p-6 rounded-2xl border border-white/10 relative overflow-hidden group">
                        <div class="absolute right-0 top-0 p-4 opacity-10 group-hover:opacity-20 transition-opacity">
                            <span class="material-symbols-outlined text-6xl">stars</span>
                        </div>
                        <p class="text-gray-500 text-xs font-bold uppercase tracking-wider mb-1">Points Awarded</p>
                        <h3 class="text-3xl font-black text-primary"><?php echo number_format($totalPoints); ?></h3>
                    </div>

                    <!-- Requests -->
                    <div class="glass-panel p-6 rounded-2xl border border-white/10 relative overflow-hidden group">
                        <div class="absolute right-0 top-0 p-4 opacity-10 group-hover:opacity-20 transition-opacity">
                            <span class="material-symbols-outlined text-6xl">pending_actions</span>
                        </div>
                        <p class="text-gray-500 text-xs font-bold uppercase tracking-wider mb-1">Pending Requests</p>
                        <h3 class="text-3xl font-black <?php echo $pendingRequestsCount > 0 ? 'text-yellow-400' : 'text-white'; ?>"><?php echo number_format($pendingRequestsCount); ?></h3>
                    </div>
                </div>

                <!-- Recent Activity -->
                <div class="glass-panel rounded-2xl overflow-hidden">
                    <div class="p-6 border-b border-white/5 flex justify-between items-center">
                        <h3 class="font-bold text-white">Recent Points Activity</h3>
                        <a href="logs.php" class="text-xs font-bold text-primary hover:text-white transition-colors uppercase tracking-wider">View All</a>
                    </div>
                    <div class="overflow-x-auto">
                        <table class="w-full text-left border-collapse">
                            <tbody class="divide-y divide-white/5 text-sm">
                                <?php foreach ($logs as $log): ?>
                                <tr class="hover:bg-white/5 transition-colors">
                                    <td class="p-4 pl-6 text-gray-400 whitespace-nowrap font-mono text-xs"><?php echo date('H:i', strtotime($log['created_at'])); ?></td>
                                    <td class="p-4">
                                        <span class="font-bold text-white"><?php echo htmlspecialchars($log['username'] ?? 'System'); ?></span>
                                        <span class="text-gray-500 mx-1">awarded</span>
                                        <span class="text-primary font-bold"><?php echo htmlspecialchars($log['points_given']); ?> pts</span>
                                        <span class="text-gray-500 mx-1">to</span>
                                        <span class="text-white"><?php echo htmlspecialchars($log['participant_name']); ?></span>
                                    </td>
                                    <td class="p-4 text-gray-400 text-xs uppercase tracking-wider"><?php echo htmlspecialchars($log['game_name']); ?></td>
                                </tr>
                                <?php endforeach; ?>
                                <?php if (empty($logs)): ?>
                                    <tr><td colspan="3" class="p-6 text-center text-gray-500">No recent activity.</td></tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>

            </div>
        </div>
    </main>
</body>
</html>