<?php
require_once '../config/database.php';

if (!isset($_SESSION['unique_id'])) {
    header("Location: login.php");
    exit;
}

$unique_id = $_SESSION['unique_id'];
$message = '';
$error = '';

// Fetch current details
$stmt = $pdo->prepare("SELECT * FROM participants WHERE unique_id = ?");
$stmt->execute([$unique_id]);
$user = $stmt->fetch();

if (!$user) {
    header("Location: login.php");
    exit;
}

// Check for existing pending request
$stmt = $pdo->prepare("SELECT * FROM profile_edit_requests WHERE participant_id = ? AND status = 'pending'");
$stmt->execute([$user['id']]);
$pendingRequest = $stmt->fetch();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if ($pendingRequest) {
        $error = "You already have a pending request. Please wait for approval.";
    } else {
        $name = trim($_POST['name']);
        $college = trim($_POST['college']);
        $year = trim($_POST['year']);
        $department = trim($_POST['department']);
        $phone = trim($_POST['phone']);

        if (empty($name) || empty($college) || empty($year) || empty($department) || empty($phone)) {
            $error = "All fields are required.";
        } else {
            $stmt = $pdo->prepare("INSERT INTO profile_edit_requests (participant_id, new_name, new_college, new_year, new_department, new_phone) VALUES (?, ?, ?, ?, ?, ?)");
            $stmt->execute([$user['id'], $name, $college, $year, $department, $phone]);
            $message = "Request submitted successfully! Waiting for admin approval.";
            // Refresh pending request check
            $pendingRequest = true; 
        }
    }
}

include '../views/header.php';
?>

<div class="row justify-content-center">
    <div class="col-md-8 col-lg-6">
        <div class="card shadow-soft">
            <div class="card-header bg-primary text-white">
                <h4 class="mb-0 h5">Edit Profile Request</h4>
            </div>
            <div class="card-body">
                <?php if ($message): ?>
                    <div class="alert alert-success"><?php echo htmlspecialchars($message); ?></div>
                <?php endif; ?>
                <?php if ($error): ?>
                    <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
                <?php endif; ?>

                <?php if ($pendingRequest): ?>
                    <div class="alert alert-warning">
                        <h5 class="alert-heading h6">Request Pending</h5>
                        <p class="mb-0 small">You have submitted changes that are currently being reviewed by an administrator. You cannot submit a new request until this one is processed.</p>
                    </div>
                    <a href="profile.php" class="btn btn-secondary w-100">Back to Profile</a>
                <?php else: ?>
                    <form method="POST">
                        <div class="mb-3">
                            <label class="form-label">Full Name</label>
                            <input type="text" class="form-control" name="name" value="<?php echo htmlspecialchars($user['name']); ?>" required>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">College Name</label>
                            <input type="text" class="form-control" name="college" value="<?php echo htmlspecialchars($user['college']); ?>" required>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Year of Study</label>
                            <select class="form-select" name="year" required>
                                <option value="1" <?php echo ($user['year'] == '1') ? 'selected' : ''; ?>>1st Year</option>
                                <option value="2" <?php echo ($user['year'] == '2') ? 'selected' : ''; ?>>2nd Year</option>
                                <option value="3" <?php echo ($user['year'] == '3') ? 'selected' : ''; ?>>3rd Year</option>
                                <option value="4" <?php echo ($user['year'] == '4') ? 'selected' : ''; ?>>4th Year</option>
                            </select>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Department</label>
                            <input type="text" class="form-control" name="department" value="<?php echo htmlspecialchars($user['department']); ?>" required>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Phone Number</label>
                            <input type="tel" class="form-control" name="phone" value="<?php echo htmlspecialchars($user['phone']); ?>" required>
                        </div>

                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-primary">Submit Request</button>
                            <a href="profile.php" class="btn btn-outline-secondary">Cancel</a>
                        </div>
                    </form>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php include '../views/footer.php'; ?>