<?php
// Determine user role for navbar
$isAdmin = isset($_SESSION['admin_id']);
$isParticipant = isset($_SESSION['unique_id']);
$isSuper = $isAdmin && ($_SESSION['role'] ?? '') === 'super';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>College Event System</title>
    <!-- Bootstrap 5 CDN -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Global CSS -->
    <link rel="stylesheet" href="css/global.css">
</head>
<body>

<nav class="navbar navbar-expand-lg navbar-dark bg-primary shadow-sm mb-4 no-print">
  <div class="container-fluid">
    <a class="navbar-brand" href="index.php">EventSys</a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="navbarNav">
      <ul class="navbar-nav ms-auto">
        
        <?php if ($isAdmin): ?>
            <!-- Admin Nav -->
            <li class="nav-item"><a class="nav-link" href="<?php echo $isSuper ? 'super_admin_dashboard.php' : 'admin_dashboard.php'; ?>">Dashboard</a></li>
            <li class="nav-item"><a class="nav-link" href="scan.php">Assign Points</a></li>
            <?php if ($isSuper): ?>
                <li class="nav-item"><a class="nav-link" href="admin_logs.php">Logs</a></li>
                <li class="nav-item"><a class="nav-link" href="manage_games.php">Manage Games</a></li>
                <li class="nav-item"><a class="nav-link" href="manage_admins.php">Manage Admins</a></li>
            <?php endif; ?>
            <li class="nav-item"><a class="nav-link text-warning" href="admin_logout.php">Logout</a></li>

        <?php elseif ($isParticipant): ?>
            <!-- Participant Nav -->
            <li class="nav-item"><a class="nav-link" href="index.php">Home</a></li>
            <li class="nav-item"><a class="nav-link" href="ranking.php">Leaderboard</a></li>
            <li class="nav-item"><a class="nav-link" href="profile.php">My Profile</a></li>
            <li class="nav-item"><a class="nav-link text-warning" href="logout.php">Logout</a></li>

        <?php else: ?>
            <!-- Public Nav -->
            <li class="nav-item"><a class="nav-link" href="index.php">Home</a></li>
            <li class="nav-item"><a class="nav-link" href="ranking.php">Leaderboard</a></li>
            <li class="nav-item"><a class="nav-link" href="register.php">Register</a></li>
            <li class="nav-item"><a class="nav-link" href="login.php">Login</a></li>
            <li class="nav-item"><a class="nav-link" href="game_login.php">Admin</a></li>
        <?php endif; ?>

        <!-- Dark Mode Toggle -->
        <li class="nav-item ms-2">
            <button class="btn btn-sm btn-outline-light" onclick="toggleDarkMode()">🌓</button>
        </li>
      </ul>
    </div>
  </div>
</nav>

<main class="container">
