<?php
require_once '../config/database.php';

if (!isset($_SESSION['admin_id'])) {
    header("Location: admin_login.php");
    exit;
}

// Fetch Stats
$totalParticipants = $pdo->query("SELECT COUNT(*) FROM participants")->fetchColumn();
$totalGames = $pdo->query("SELECT COUNT(*) FROM games")->fetchColumn();
$totalPoints = $pdo->query("SELECT SUM(points) FROM participant_points")->fetchColumn();
$totalPoints = $totalPoints ? $totalPoints : 0;

include '../views/header.php';
?>
<link rel="stylesheet" href="css/admin_dashboard.css">
<div>
    <h2 class="mb-4">Game Controller Dashboard</h2>
    
    <div class="row g-4">
        <!-- Total Participants -->
        <div class="col-md-4">
            <div class="card stat-card bg-primary text-white shadow-soft">
                <div class="card-body d-flex justify-content-between align-items-center">
                    <div>
                        <h5 class="card-title">Participants</h5>
                        <h2 class="mb-0"><?php echo $totalParticipants; ?></h2>
                    </div>
                    <div class="stat-icon">👥</div>
                </div>
            </div>
        </div>

        <!-- Total Games -->
        <div class="col-md-4">
            <div class="card stat-card bg-success text-white shadow-soft">
                <div class="card-body d-flex justify-content-between align-items-center">
                    <div>
                        <h5 class="card-title">Games</h5>
                        <h2 class="mb-0"><?php echo $totalGames; ?></h2>
                    </div>
                    <div class="stat-icon">🎮</div>
                </div>
            </div>
        </div>

        <!-- Total Points Assigned -->
        <div class="col-md-4">
            <div class="card stat-card bg-purple text-white shadow-soft">
                <div class="card-body d-flex justify-content-between align-items-center">
                    <div>
                        <h5 class="card-title">Points Assigned</h5>
                        <h2 class="mb-0"><?php echo $totalPoints; ?></h2>
                    </div>
                    <div class="stat-icon">🏆</div>
                </div>
            </div>
        </div>
    </div>

    <div class="row mt-5">
        <div class="col-12">
            <a href="scan.php" class="text-decoration-none">
                <div class="card shadow-soft p-5 text-center bg-light border-primary border-2">
                    <h1 class="display-4 text-primary mb-3">📷</h1>
                    <h3 class="text-primary">Scan QR & Assign Points</h3>
                    <p class="text-muted lead">Click here to start scanning participant codes.</p>
                </div>
            </a>
        </div>
    </div>
</div>

<?php include '../views/footer.php'; ?>