<?php
require_once '../config/database.php';
include '../views/header.php';

$search = trim($_GET['search'] ?? '');
$params = [];

// Fetch participants with total points
$sql = "SELECT p.name, p.college, p.department, COALESCE(SUM(pp.points), 0) as total_points 
        FROM participants p 
        LEFT JOIN participant_points pp ON p.id = pp.participant_id";

if (!empty($search)) {
    $sql .= " WHERE p.name LIKE ?";
    $params[] = "%$search%";
}

$sql .= " GROUP BY p.id ORDER BY total_points DESC, p.name ASC";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$participants = $stmt->fetchAll();
?>

<!-- Page Specific CSS -->
<link rel="stylesheet" href="css/ranking.css">

<div class="row justify-content-center">
    <div class="col-lg-10">
        <div class="text-center mb-4">
            <h2 class="fw-bold text-primary">🏆 Leaderboard</h2>
            <p class="text-muted">Top performers ranked by total points</p>
        </div>

        <form class="d-flex mb-4 justify-content-center" method="GET" action="ranking.php">
            <div class="input-group" style="max-width: 500px;">
                <input class="form-control" type="search" name="search" placeholder="Search participant..." value="<?php echo htmlspecialchars($search); ?>">
                <button class="btn btn-primary" type="submit">Search</button>
                <?php if($search): ?>
                    <a href="ranking.php" class="btn btn-outline-secondary">Reset</a>
                <?php endif; ?>
            </div>
        </form>

        <?php if (count($participants) > 0): ?>
            <div class="table-responsive">
                <table class="table table-hover ranking-table align-middle shadow-soft">
                    <thead>
                        <tr>
                            <th scope="col" class="text-center" style="width: 80px;">Rank</th>
                            <th scope="col">Participant</th>
                            <th scope="col">College</th>
                            <th scope="col">Department</th>
                            <th scope="col" class="text-center">Total Points</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php 
                        $rank = 1;
                        foreach ($participants as $p): 
                            $rankClass = $rank <= 3 ? 'top-' . $rank : '';
                        ?>
                        <tr class="<?php echo $rankClass; ?>">
                            <td class="text-center">
                                <span class="rank-badge"><?php echo $rank++; ?></span>
                            </td>
                            <td class="fw-bold"><?php echo htmlspecialchars($p['name']); ?></td>
                            <td><?php echo htmlspecialchars($p['college']); ?></td>
                            <td><?php echo htmlspecialchars($p['department']); ?></td>
                            <td class="text-center fw-bold text-primary fs-5">
                                <?php echo $p['total_points']; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <div class="alert alert-info text-center shadow-sm">
                No participants found.
            </div>
        <?php endif; ?>
    </div>
</div>

<?php include '../views/footer.php'; ?>